from collections import Counter
import sys

def solve_konacno():
    # ?????????? ?? ???????? ??????
    try:
        ulaz = sys.stdin.readlines()
        if not ulaz: return 0
        N = int(ulaz[0].strip())
    except:
        return 0
    
    if N <= 1:
        return 0

    # ????? ?? ??????????? ??????
    points = []
    for linija in ulaz[1:N+1]:
        try:
            x, y = map(int, linija.strip().split())
            points.append((x, y))
        except:
            continue
            
    # ???????? ?? ????????????
    kljucevi_suma = []        # x + y (Anti-Dijagonala)
    kljucevi_razlika = []     # x - y (Dijagonala)
    
    # ?? ??????? ?? ?????
    kljucevi_x = []           # x (Vertikala)
    kljucevi_y = []           # y (Horizontala)

    # ?????? ???? ????????
    ukupan_broj_pozdrava = 0
    
    for x, y in points:
        kljucevi_suma.append(x + y)
        kljucevi_razlika.append(x - y)
        # ?? ??????? ?? ?????:
        # ?????? ???? x ? y, ?????? ???? ?????.
        # ?? ???? ????????, ??? ???? ?????? ?????????
        # ?????????? ????? `points` ?? ??????? ????????.
        
    # --- 1. ??????? ???? 1 ? 2 (2 ???????? ?? ????) ---
    # ????????? ??????? k * (k-1)
    
    def pozdravi_za_grupu(k):
        if k < 2: return 0
        return k * (k - 1)
        
    # ????-?????????? (x + y)
    broj_po_sumi = Counter(kljucevi_suma)
    for k in broj_po_sumi.values():
        ukupan_broj_pozdrava += pozdravi_za_grupu(k)

    # ?????????? (x - y)
    broj_po_razlici = Counter(kljucevi_razlika)
    for k in broj_po_razlici.values():
        ukupan_broj_pozdrava += pozdravi_po_grupi(k)

    # --- 2. ??????? ???? 3 (1 ??????? ?? ????) ---
    
    # ??? ??????? O(N^2) ???????, ??? ?? ????????. 
    # ??????, ?????? ??????? ?? ????????? ????.
    
    # 2.1. ??????? ?? ????? ????????? (x-osa): x_i = x_j
    # ????? ?? ?????? (N vs S): |y_i - y_j| ???? ???? ?????.
    
    # ????????? ????? ?? X ??????????
    grupe_po_x = Counter()
    for x, y in points:
        grupe_po_x[x] += 1
        
    for x_koordinata in grupe_po_x.keys():
        if grupe_po_x[x_koordinata] >= 2:
            
            # ????????? ??? Y ?????????? ?? ??? X
            y_koordinate_grupe = [y for px, y in points if px == x_koordinata]
            
            # ??????? ?????? Y ?????????? ???? ????? ????? ???????
            k_grupa = len(y_koordinate_grupe)
            for i in range(k_grupa):
                for j in range(i + 1, k_grupa):
                    # ??????? ???????? ???????: |y_i - y_j| % 2 == 0
                    if (y_koordinate_grupe[i] - y_koordinate_grupe[j]) % 2 == 0:
                        # ?????? (N vs S)
                        ukupan_broj_pozdrava += 1

    # 2.2. ??????? ?? ????? ??????????? (y-osa): y_i = y_j
    # ????? ?? ?????? (E vs W): |x_i - x_j| ???? ???? ?????.

    # ????????? ????? ?? Y ??????????
    grupe_po_y = Counter()
    for x, y in points:
        grupe_po_y[y] += 1
        
    for y_koordinata in grupe_po_y.keys():
        if grupe_po_y[y_koordinata] >= 2:
            
            # ????????? ??? X ?????????? ?? ??? Y
            x_koordinate_grupe = [x for x, py in points if py == y_koordinata]
            
            # ??????? ?????? X ?????????? ???? ????? ????? ???????
            k_grupa = len(x_koordinate_grupe)
            for i in range(k_grupa):
                for j in range(i + 1, k_grupa):
                    # ??????? ???????? ???????: |x_i - x_j| % 2 == 0
                    if (x_koordinate_grupe[i] - x_koordinate_grupe[j]) % 2 == 0:
                        # ?????? (E vs W)
                        ukupan_broj_pozdrava += 1

    # ????????: ??????? ????????? ????? ?? ?? ??? ????? ? O(N log N)
    # ??????????, ??? ?? N=200,000, ???? O(N * (k^2)) ??????? ???? ????
    # ?????????? ??? ?? ????? ?? X ? Y ????.

    return ukupan_broj_pozdrava

print(solve_konacno())